# 外部播放器配置说明

本文档说明如何配置VLC和MPV播放器以支持自定义协议唤起。

## 配置步骤

### 1. 修改注册表文件中的播放器路径

根据您的实际安装路径修改注册表文件：

#### vlc-protocol.reg
```reg
Windows Registry Editor Version 5.00

[HKEY_CLASSES_ROOT\vlc]
@="URL:VLC Protocol"
"URL Protocol"=""

[HKEY_CLASSES_ROOT\vlc\shell]

[HKEY_CLASSES_ROOT\vlc\shell\open]

[HKEY_CLASSES_ROOT\vlc\shell\open\command]
@="\"C:\\Program Files\\VideoLAN\\VLC\\vlc.exe\" \"%1\""
```

#### mpv-protocol.reg
```reg
Windows Registry Editor Version 5.00

[HKEY_CLASSES_ROOT\mpv]
@="URL:MPV Protocol"
"URL Protocol"=""

[HKEY_CLASSES_ROOT\mpv\shell]

[HKEY_CLASSES_ROOT\mpv\shell\open]

[HKEY_CLASSES_ROOT\mpv\shell\open\command]
@="\"C:\\Program Files\\mpv\\mpv.exe\" \"%1\""
```

**注意**: 请根据您的实际安装路径修改播放器的路径。常见路径：
- VLC: `C:\Program Files\VideoLAN\VLC\vlc.exe`
- MPV: `C:\Program Files\mpv\mpv.exe` 或 `C:\mpv\mpv.exe`

### 2. 注册协议

以管理员身份运行以下注册表文件：

1. 右键点击 `vlc-protocol.reg` → 选择"合并"
2. 右键点击 `mpv-protocol.reg` → 选择"合并"

### 3. 测试配置

配置完成后，您可以在浏览器地址栏中测试：

- VLC: `vlc://https://example.com/video.mp4`
- MPV: `mpv://https://example.com/video.mp4`

## 工作原理

当您点击"用VLC播放"或"用MPV播放"按钮时：

1. JavaScript代码构造 `vlc://` 或 `mpv://` 协议URL
2. 浏览器识别自定义协议并查找注册表中的处理程序
3. 系统调用对应的播放器，并将完整URL作为参数传递
4. 播放器接收到URL参数（如 `vlc://https://example.com/video.mp4`）
5. 播放器会自动处理协议前缀，提取真实的视频URL进行播放

## 常见问题

### Q: 如何确认配置是否成功？
A: 在浏览器地址栏输入测试URL，如果能够成功调起对应的播放器，说明配置成功。

### Q: 播放器路径不正确怎么办？
A: 请根据您的实际安装路径修改注册表文件中的播放器路径。

### Q: 为什么有时候播放器无法打开视频？
A: 可能是因为：
1. 视频URL需要特殊的请求头（如Referer）
2. 视频格式不被播放器支持
3. 网络连接问题

## 卸载协议

如果需要卸载协议，可以创建卸载的注册表文件：

```reg
Windows Registry Editor Version 5.00

[-HKEY_CLASSES_ROOT\vlc]
[-HKEY_CLASSES_ROOT\mpv]
```

保存为 `.reg` 文件并以管理员身份运行即可删除协议注册。